#!/bin/bash
export datasets="Cora CiteSeer PubMed cs physics wikics OGBN-Arxiv"
# export datasets2="OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_test="0.999"
export vers="0"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export lp_temp_list="0.005 0.01 0.05 0.1 0.5 5 10.0"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2

# uniform
for ver in $vers
do
for missing_rate in $missing_rates_test
do
for lp_temp in $lp_temp_list
do
python main.py --dataset Cora --missing_type uniform --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset CiteSeer --missing_type uniform --lamb 1e-4 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset PubMed --missing_type uniform --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset cs --missing_type uniform --lamb 1e+0 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset physics --missing_type uniform --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset wikics --missing_type uniform --lamb 1e+0 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset OGBN-Arxiv --missing_type uniform --lamb 1e-4 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
done
done
done

# row
for ver in $vers
do
for missing_rate in $missing_rates_test
do
for lp_temp in $lp_temp_list
do
python main.py --dataset Cora --missing_type row --lamb 1e-4 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset CiteSeer --missing_type row --lamb 1e-2 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset PubMed --missing_type row --lamb 1e-5 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset cs --missing_type row --lamb 1e-1 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset physics --missing_type row --lamb 1e-4 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset wikics --missing_type row --lamb 1e+0 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset OGBN-Arxiv --missing_type row --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
done
done
done

# uniform
for ver in 1
do
for missing_rate in 0.5
do
for lp_temp in 0.5 5 10.0
do
python main.py --dataset Cora --missing_type uniform --lamb 1e-2 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset CiteSeer --missing_type uniform --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset PubMed --missing_type uniform --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset cs --missing_type uniform --lamb 1e+1 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset physics --missing_type uniform --lamb 1e-3 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset wikics --missing_type uniform --lamb 1e+1 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
python main.py --dataset OGBN-Arxiv --missing_type uniform --lamb 1e-4 --lp_temp ${lp_temp} --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
done
done
done